/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jtbcore.db.parser.BaseTokenizer;
import jtbcore.exception.InvalidStateException;
import jtbcore.util.StringUtil;

public class SelectSqlParser
extends BaseTokenizer {
    protected List<ExpressionSpec> exprSpecs;
    protected SelectExpression exprSelect = null;
    protected FromExpression exprFrom = null;
    protected List<JoinExpression> exprJoins = new ArrayList<JoinExpression>();
    protected WhereExpression exprWhere = null;
    protected GroupByExpression exprGroupBy = null;
    protected HavingExpression exprHaving = null;
    protected WindowExpression exprWindow = null;
    protected OrderByExpression exprOrderBy = null;
    protected LimitExpression exprLimit = null;
    protected List<Object> params = new ArrayList<Object>();

    public SelectSqlParser() {
        this.exprSpecs = new ArrayList<ExpressionSpec>();
        this.exprSpecs.add(new ExpressionSpec(SelectExpression.class, new String[]{"SELECT"}));
        this.exprSpecs.add(new ExpressionSpec(FromExpression.class, new String[]{"FROM"}));
        this.exprSpecs.add(new ExpressionSpec(JoinExpression.class, new String[]{"JOIN", "INNER JOIN", "INNER STRAIGHT_JOIN", "CROSS JOIN", "CROSS STRAIGHT_JOIN", "LEFT OUTER JOIN", "LEFT JOIN", "RIGHT OUTER JOIN", "RIGHT JOIN", "NATURAL LEFT OUTER JOIN", "NATURAL LEFT JOIN", "NATURAL RIGHT OUTER JOIN", "NATURAL RIGHT JOIN"}));
        this.exprSpecs.add(new ExpressionSpec(WhereExpression.class, new String[]{"WHERE"}));
        this.exprSpecs.add(new ExpressionSpec(GroupByExpression.class, new String[]{"GROUP BY"}));
        this.exprSpecs.add(new ExpressionSpec(HavingExpression.class, new String[]{"HAVING"}));
        this.exprSpecs.add(new ExpressionSpec(WindowExpression.class, new String[]{"WINDOW"}));
        this.exprSpecs.add(new ExpressionSpec(OrderByExpression.class, new String[]{"ORDER BY"}));
        this.exprSpecs.add(new ExpressionSpec(LimitExpression.class, new String[]{"LIMIT"}));
    }

    public void parseSql(String sql, Object ... params) throws IOException, InvalidStateException {
        this.setParams(params);
        this.parse(sql);
        this.removeWhiteTokens();
        List<String> tokens = this.getTokens();
        int i = 0;
        int parenthesis = 0;
        ExpressionBase curExpr = null;
        int markStart = 0;
        int markCount = 0;
        int totalMarkCount = 0;
        i = 0;
        while (i < tokens.size()) {
            ExpressionSpec nextEs;
            int c = StringUtil.occurrences(tokens.get(i), '?');
            markCount += StringUtil.occurrences(tokens.get(i), '?').intValue();
            totalMarkCount += c;
            if ((parenthesis += StringUtil.occurrences(tokens.get(i), '(').intValue()) == 0 && (nextEs = this.startExpression(tokens, i)) != null) {
                if (curExpr != null && markCount > 0) {
                    if (this.params.size() < markStart + markCount) {
                        throw new InvalidStateException("Marks / params not equal");
                    }
                    curExpr.params = this.params.subList(markStart, markStart + markCount);
                }
                curExpr = this.createExpression(nextEs);
                markStart += markCount;
                markCount = 0;
                int startKeywords = nextEs.startExpression(tokens, i);
                int counter = 0;
                while (i < tokens.size() && counter < startKeywords) {
                    curExpr.addToken(tokens.get(i));
                    if (counter < startKeywords - 1) {
                        ++i;
                    }
                    ++counter;
                }
            } else {
                if (curExpr != null) {
                    curExpr.addToken(tokens.get(i));
                }
                parenthesis -= StringUtil.occurrences(tokens.get(i), ')').intValue();
            }
            ++i;
        }
        if (totalMarkCount > this.params.size()) {
            throw new InvalidStateException("Marks / params not equal");
        }
    }

    public void setParams(Object ... params) {
        this.params = new ArrayList<Object>();
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.params.add(o);
            ++n2;
        }
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public void addWhere(String sql, Object ... params) {
        if (this.exprWhere == null) {
            this.exprWhere = new WhereExpression();
        }
        this.exprWhere.addWhere(sql, params);
    }

    public String toSql() {
        StringBuilder b = new StringBuilder();
        if (this.exprSelect != null) {
            b.append(this.exprSelect.toSql());
            b.append("\n");
        }
        if (this.exprFrom != null) {
            b.append(this.exprFrom.toSql());
            b.append("\n");
        }
        if (this.exprJoins != null) {
            for (JoinExpression je : this.exprJoins) {
                b.append(je.toSql());
                b.append("\n");
            }
        }
        if (this.exprWhere != null) {
            b.append(this.exprWhere.toSql());
            b.append("\n");
        }
        if (this.exprGroupBy != null) {
            b.append(this.exprGroupBy.toSql());
            b.append("\n");
        }
        if (this.exprHaving != null) {
            b.append(this.exprHaving.toSql());
            b.append("\n");
        }
        if (this.exprWindow != null) {
            b.append(this.exprWindow.toSql());
            b.append("\n");
        }
        if (this.exprOrderBy != null) {
            b.append(this.exprOrderBy.toSql());
            b.append("\n");
        }
        if (this.exprLimit != null) {
            b.append(this.exprLimit.toSql());
            b.append("\n");
        }
        return b.toString();
    }

    public Object[] getParams() {
        ArrayList params = new ArrayList();
        if (this.exprSelect != null) {
            params.addAll(this.exprSelect.params);
        }
        if (this.exprFrom != null) {
            params.addAll(this.exprFrom.params);
        }
        if (this.exprJoins != null) {
            for (JoinExpression je : this.exprJoins) {
                params.addAll(je.params);
            }
        }
        if (this.exprWhere != null) {
            params.addAll(this.exprWhere.params);
        }
        if (this.exprGroupBy != null) {
            params.addAll(this.exprGroupBy.params);
        }
        if (this.exprHaving != null) {
            params.addAll(this.exprHaving.params);
        }
        if (this.exprWindow != null) {
            params.addAll(this.exprWindow.params);
        }
        if (this.exprOrderBy != null) {
            params.addAll(this.exprOrderBy.params);
        }
        if (this.exprLimit != null) {
            params.addAll(this.exprLimit.params);
        }
        return params.toArray();
    }

    public ExpressionBase createExpression(ExpressionSpec s) {
        if (s.expr.equals(SelectExpression.class)) {
            this.exprSelect = new SelectExpression();
            return this.exprSelect;
        }
        if (s.expr.equals(FromExpression.class)) {
            this.exprFrom = new FromExpression();
            return this.exprFrom;
        }
        if (s.expr.equals(JoinExpression.class)) {
            JoinExpression je = new JoinExpression();
            this.exprJoins.add(je);
            return je;
        }
        if (s.expr.equals(WhereExpression.class)) {
            this.exprWhere = new WhereExpression();
            return this.exprWhere;
        }
        if (s.expr.equals(GroupByExpression.class)) {
            this.exprGroupBy = new GroupByExpression();
            return this.exprGroupBy;
        }
        if (s.expr.equals(HavingExpression.class)) {
            this.exprHaving = new HavingExpression();
            return this.exprHaving;
        }
        if (s.expr.equals(WindowExpression.class)) {
            this.exprWindow = new WindowExpression();
            return this.exprWindow;
        }
        if (s.expr.equals(OrderByExpression.class)) {
            this.exprOrderBy = new OrderByExpression();
            return this.exprOrderBy;
        }
        if (s.expr.equals(LimitExpression.class)) {
            this.exprLimit = new LimitExpression();
            return this.exprLimit;
        }
        return null;
    }

    public ExpressionSpec startExpression(List<String> tokens, int p) {
        for (ExpressionSpec spec : this.exprSpecs) {
            if (spec.startExpression(tokens, p) <= 0) continue;
            return spec;
        }
        return null;
    }

    public static void main(String[] args) {
        String sql = "select id, parent_gemeente_id, `key`, title\nFROM edu2023_locatie\njoin x on x=y and x = ?\nleft join z on z=b\nwhere bla = bluh\norder by title\n";
        try {
            SelectSqlParser p = new SelectSqlParser();
            p.parseSql(sql, "blabla", "hoho");
            p.addWhere("x=y", new Object[0]);
            System.out.println("size: " + p.exprJoins.get((int)0).params.size());
            System.out.println("Test: " + p.toSql());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class ExpressionBase {
        public List<Object> params = new ArrayList<Object>();
        public List<String> tokens = new ArrayList<String>();

        public void addToken(String t) {
            this.tokens.add(t);
        }

        public String toSql() {
            StringBuilder b = new StringBuilder();
            int x = 0;
            while (x < this.tokens.size()) {
                String tok = this.tokens.get(x);
                if (x > 0 && !"(".equals(tok)) {
                    b.append(" ");
                }
                b.append(tok);
                ++x;
            }
            return b.toString();
        }
    }

    public static class ExpressionSpec {
        public Class expr = null;
        public String[] startKeywords;

        public ExpressionSpec() {
        }

        public ExpressionSpec(Class clazz, String[] keywords) {
            this.expr = clazz;
            this.startKeywords = keywords;
        }

        public int startExpression(List<String> tokens, int pos) {
            String[] stringArray = this.startKeywords;
            int n = this.startKeywords.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                String[] words = k.split(" +");
                int matchCount = 0;
                int x = 0;
                while (x + pos < tokens.size() && x < words.length) {
                    if (!tokens.get(x + pos).equalsIgnoreCase(words[x])) break;
                    ++matchCount;
                    ++x;
                }
                if (matchCount == words.length) {
                    return matchCount;
                }
                ++n2;
            }
            return -1;
        }
    }

    public static class FromExpression
    extends ExpressionBase {
    }

    public static class GroupByExpression
    extends ExpressionBase {
    }

    public static class HavingExpression
    extends ExpressionBase {
    }

    public static class JoinExpression
    extends ExpressionBase {
    }

    public static class LimitExpression
    extends ExpressionBase {
    }

    public static class OrderByExpression
    extends ExpressionBase {
    }

    public static class SelectExpression
    extends ExpressionBase {
    }

    public static class WhereExpression
    extends ExpressionBase {
        public List<String> whereQueries = new ArrayList<String>();

        public void addWhere(String sql, Object ... params) {
            Object[] objectArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.params.add(o);
                ++n2;
            }
            this.whereQueries.add(sql);
        }

        @Override
        public String toSql() {
            String sql = super.toSql();
            StringBuilder b = new StringBuilder();
            if (sql.length() > 0) {
                b.append(sql);
                b.insert(6, "(");
                b.append(")");
            }
            int x = 0;
            while (x < this.whereQueries.size()) {
                if (x == 0 && b.length() == 0) {
                    b.append("WHERE ");
                } else {
                    b.append(" AND ");
                }
                b.append("(").append(this.whereQueries.get(x)).append(")");
                ++x;
            }
            return b.toString();
        }
    }

    public static class WindowExpression
    extends ExpressionBase {
    }
}

